<?php
class SafeMage_PluginExample_Model_Plugin
{
    /**
     * @param Mage_Catalog_Model_Product $object
     * @param array $arguments
     */
    public function beforeSetData($object, array &$arguments)
    {
        list($key, $value) = $arguments;
        if ($key == 'name') {
            $value .= ' ***';
            $arguments[1] = $value;
        }
    }

    /**
     * @param Mage_Catalog_Model_Product $object
     * @param array $arguments
     */
    public function beforeSetData2($object, array &$arguments)
    {
        list($key, $value) = $arguments;
        if ($key == 'name') {
            $value .= ' ♥♥♥';
            $arguments[1] = $value;
        }
    }

    /**
     * @param Mage_Catalog_Model_Product $object
     * @param string $result
     * @param array $arguments
     * @return string product name
     */
    public function afterGetName($object, $result, array $arguments)
    {
        return $result . ' !!!';
    }

    /**
     * @param Mage_Catalog_Model_Product $object
     * @param float $result
     * @param array $arguments
     * @return float price
     */
    public function afterGetFinalPrice($object, $result, array $arguments)
    {
        return $result * 1.02;
    }

    /**
     * @param Mage_Catalog_Helper_Product $object
     * @param array $arguments
     * @return string formated price
     */
    public function aroundGetDefaultQty($object, array $arguments)
    {
        list($product) = $arguments;
        $qty = $object->getMinimalQty($product);
        return $qty * 5;
    }

    /**
     * @param Mage_Catalog_Block_Product_List $object
     * @param string $result html
     * @param array $arguments
     * @return string
     */
    public function afterAfterToHtml($object, $result, array $arguments)
    {
        return '<div>0123456789</div>' . $result;
    }
}
